<#include "header.ftl">

  <div class="w-section clj-home-header">
    <div class="w-container">
      <div class="w-row">
        <div class="w-col w-col-8">
          <div class="clj-header-message">ClojureScript is a <span class="clj-header-message-highlight">robust, practical, and fast</span> programming language with a set of useful features that together form a <span class="clj-header-message-highlight">simple, coherent, and powerful tool</span>.</div>
        </div>
        <div class="w-col w-col-4">
          <div class="clj-download-button-container"><a href="guides/quick-start" class="w-button clj-download-button">Get Started!</a>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="w-section clj-home-intro-section">
    <div class="w-container">
      <div class="w-row">
        <div class="w-col w-col-8">
          <div>
            <div class="clj-intro-message">
							<p>ClojureScript is a compiler for <a href="http://clojure.org">Clojure</a> that targets JavaScript. It emits JavaScript code which is compatible with the advanced compilation mode of the Google Closure optimizing compiler.</p>
							<h4>Why Clojure?</h4>
							<p>Clojure is a dynamic, general-purpose programming language supporting interactive development. Clojure is a functional programming language featuring a rich set of immutable, persistent data structures. As a dialect of Lisp, it has a code-as-data philosophy and a powerful macro system. </p>
							<h4>Why JavaScript?</h4>
							<p>The spread of the browser and web-based applications has given JavaScript an exclusive reach unmatched by any other language. Because of its importance, JavaScript engines are also receiving extensive research and optimization allowing JavaScript to compete for performance with many more established platforms like the JVM.</p>
							<h4>Why Google Closure?</h4>
							<p>As the purveyors of some of the most complicated client-service web applications in use today, Google has invested heavily in creating the Closure library and Closure compiler which work together to make whole program optimization possible, yielding programs that provide minimal load times even when using many libraries.</p>
							<h4>Opportunity</h4>
							<p>ClojureScript combines the reach of the JavaScript platform, the flexibility and interactive development of Clojure, and the whole-program optimization of Google Closure to provide the most powerful language for programming the web.</p>
            </div>
          </div>
        </div>
        <div class="w-col w-col-4">
          <div class="clj-learn-more">
            <h3 class="clj-learn-more-heading">Learn More</h3>
            <a href="https://github.com/clojure/clojurescript/blob/master/changes.md" class="w-inline-block clj-learn-more-item">
              <h4 class="clj-learn-more-item-heading">Release</h4>
              <p class="clj-learn-more-detail">Current version: ${config.cljsversion}</p>
            </a>
            <a href="about/rationale" class="w-inline-block clj-learn-more-item">
              <h4 class="clj-learn-more-item-heading">Rationale</h4>
              <p class="clj-learn-more-detail">A brief overview of ClojureScript</p>
            </a>
            <a href="reference/documentation" class="w-inline-block clj-learn-more-item">
              <h4 class="clj-learn-more-item-heading">Reference</h4>
              <p class="clj-learn-more-detail">Detailed reference material</p>
            </a>
            <a href="guides/guides" class="w-inline-block clj-learn-more-item">
              <h4 class="clj-learn-more-item-heading">Guides</h4>
              <p class="clj-learn-more-detail">Walkthroughs to help you learn along the way</p>
            </a>
            <a href="community/resources" class="w-inline-block clj-learn-more-item">
              <h4 class="clj-learn-more-item-heading">Community</h4>
              <p class="clj-learn-more-detail">Join our community</p>
            </a>
            <a href="https://www.youtube.com/user/ClojureTV/videos">
              <img src="/images/clojuretv.png" alt="Clojure TV logo">
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="w-section clj-home-companies-section">
    <div class="w-container">
      <div>
        <h3 class="clj-home-companies-heading">Companies Succeeding with ClojureScript</h3>
      </div>
      <div class="w-row">
        <div class="w-col w-col-4">
          <div class="clj-home-company clj-home-company-walmart">
            <blockquote class="clj-home-company-quote">“Learning to use ClojureScript, Om, and React finally made me feel like I was taking ownership of my design work from beginning to end.”</blockquote>
            <div class="clj-home-company-attribution">Danny King, Co-Founder/Designer
              <br>Precursor</div>
          </div>
        </div>
        <div class="w-col w-col-4">
          <div class="clj-home-company clj-home-company-puppet">
            <blockquote class="clj-home-company-quote">“[We designed our software] with just immutable data structures and pure functions (with much less code than traditional OO languages) allowing us to focus on our core business requirements rather than inherent technological problems.”</blockquote>
            <div class="clj-home-company-attribution">Asier Galdos, Co-founder/developer
              <br>Greenius</div>
          </div>
        </div>
        <div class="w-col w-col-4">
          <div class="clj-home-company clj-home-company-thoughtworks">
            <blockquote class="clj-home-company-quote">“Clojure and Clojurescript are the backbone of our business.”<br/><br/>
						“Clojurescript offers a language and environment that is far superior (and less error-prone) than plain-ol' Javascript, even with frameworks.“</blockquote>
            <div class="clj-home-company-attribution">
              <br>State of Clojure 2015 survey</div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="w-section clj-home-support">
    <div class="w-container">
      <div class="w-row">
        <div class="w-col w-col-8">
          <div>
            <h3>Nubank</h3>
            <p><a href="https://international.nubank.com.br/">Nubank</a> is one of the world's largest digital banking platforms, serving over 100 million customers across Brazil, Mexico, and Colombia. From its start, Nu has had a spectacular success story with Clojure, running mission-critical software at scale. In 2020, the company acquired Cognitect, the consultancy behind Clojure and the <a href="https://www.datomic.com/">Datomic</a> database.</p>
            <p>Through the acquisition, Nubank incorporated a world-class team to assist developers in translating Clojure's ideas into business agility and leverage the company's mission to fight complexity and empower people. Currently, Nu is a key corporate sponsor of Clojure and ClojureScript.</p>
            <p>For more information about how Nubank builds products and teams, visit <a href="https://building.nubank.com.br/">building.nubank.com.br</a>.</p>
          </div>
        </div>
        <div class="w-col w-col-4 clj-home-support-logo-container">
          <img class="clj-home-support-logo" src="/images/nulogo.png"/>
        </div>
      </div>
    </div>
  </div>

<#include "footer.ftl">
